<?php

/**
 * Plugin Name:     Stepper
 * Plugin URI:      PLUGIN SITE HERE
 * Description:     PLUGIN DESCRIPTION HERE
 * Author:          Philipp Lang
 * Author URI:      YOUR SITE HERE
 * Text Domain:     stepper
 * Domain Path:     /languages
 * Version:         0.1.0
 *
 * @package         Stepper
 */

require_once(__DIR__ . '/vendor/autoload.php');
require_once(__DIR__ . '/settings.php');

use Zoomyboy\Stepper\Stepper;

register_activation_hook(__FILE__, function () {
	add_option('it-slider-options', [
		'it-slider-color' => '#006600',
		'it-slider-access-key' => null,
	]);
});

register_deactivation_hook(__FILE__, function () {
	delete_option('it-slider-options');
});

add_action('admin_enqueue_scripts', function () {
	wp_enqueue_style('it-admin-styles', plugin_dir_url(__FILE__) . '/assets/css/backend.css');
});

$stepper = new Stepper();
$stepper->loadEnv(__DIR__);
$stepper->url = plugin_dir_url(__FILE__);
$stepper->scriptUrl = file_exists(__DIR__ . '/assets/public/hot')
	? 'http://localhost:8080/'
	: plugin_dir_url(__FILE__) . 'assets/public/';
$stepper->initFrontend();
