<?php

function it_render_template($template, $args)
{
	extract($args);
	extract(['pluginDir' => plugin_dir_url(__FILE__)]);
	include(__DIR__ . '/templates/' . $template);
}

add_action('admin_init', function () {
	register_setting('it-slider', 'it-slider-options');
	add_settings_section('it-slider-section', 'Stellen Sie hier Ihren Immobilien-Slider ein.', fn () => '', 'it-slider');

	add_settings_field('it-slider-color-field', 'Primäre Farbe', function ($args) {
		$options = get_option('it-slider-options');
		it_render_template('color-input.htm', ['value' => $options[$args['key']], 'name' => $args['key']]);
	}, 'it-slider', 'it-slider-section', ['key' => 'it-slider-color']);

	add_settings_field('it-slider-access-key-field', 'Access Key', function ($args) {
		$options = get_option('it-slider-options');
		it_render_template('access-key-input.htm', ['value' => $options[$args['key']], 'name' => $args['key']]);
	}, 'it-slider', 'it-slider-section', ['key' => 'it-slider-access-key']);
});

add_action('admin_menu', function () {
	add_submenu_page(
		'options-general.php',
		'Immotooler Slider',
		'Immotooler Slider',
		'manage_options',
		'immotooler-slider',
		function () {
			if (!current_user_can('manage_options')) {
				return;
			}

			settings_errors('wporg_messages');
			echo it_render_template('settings-body.htm', []);
		}
	);
});
