import axios from 'axios';
import VueAxios from 'vue-axios';
import {Carousel, Slide} from 'vue3-carousel';
import {createApp} from 'vue';
import wNumb from 'wnumb';
import Stepper from './Stepper.vue';
import RadioGrid from './components/RadioGrid.vue';
import Pagination from './components/Pagination.vue';
import VBtn from './components/VBtn.vue';
import VText from './components/VText.vue';
import VCheckbox from './components/VCheckbox.vue';
import svg from './svg.mixin.js';
import VSlider from './components/VSlider.vue';

import 'vue3-carousel/dist/carousel.css';
import '../css/fix-carousel.css';
import '../css/slider-default.css';

var app = createApp()
    .mixin(svg)
    .use(VueAxios, axios)
    .component('radio-grid', RadioGrid)
    .component('carousel', Carousel)
    .component('slide', Slide)
    .component('stepper', Stepper)
    .component('v-btn', VBtn)
    .component('pagination', Pagination)
    .component('v-checkbox', VCheckbox)
    .component('v-slider', VSlider)
    .component('v-text', VText);

app.provide('axios', app.config.globalProperties.axios);
app.mount(document.getElementById('stepper-main'));

var units = (window.units = {
    currency: wNumb({
        mark: ',',
        thousand: '.',
        prefix: '',
        suffix: '',
        decimals: 0,
    }),
    decimalCurrency: wNumb({
        mark: ',',
        thousand: '.',
        prefix: '',
        suffix: '',
        decimals: 2,
    }),
    percent: wNumb({
        mark: ',',
        thousand: '',
        prefix: '',
        suffix: '',
        decimals: 2,
    }),
});
